<?php
  use Elementor\Icons_Manager;
  use Elementor\Group_Control_Image_Size;
  $settings = $this->get_settings_for_display();
  if ( empty( $settings['title_text'] ) ) {
    return;
  }
  $style = $settings['style'];
  $title_text = $settings['title_text'];
  $description_text = $settings['description_text'];
  $this->add_render_attribute( 'block', 'class', [ 'image-box', 'image-box-'.$settings['style'] ] );
   
  $this->add_render_attribute( 'title_text', 'class', 'title' );
  $this->add_render_attribute( 'description_text', 'class', 'desc' );

  $this->add_inline_editing_attributes( 'title_text', 'none' );
  $this->add_inline_editing_attributes( 'description_text' );

  $this->add_render_attribute('href', 'href', esc_url($settings['link']['url']));
if($settings['link']['is_external']) {
	$this->add_render_attribute('href', 'target', '_blank');
}
if(!empty($settings['link']['nofollow'])) {
	$this->add_render_attribute('href', 'rel', 'nofollow');
}?>

<?php if($style == 'style1'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <div class="img-perspective">
      <?php if (!empty($settings['image']['url'])) : 
          $image_url = $settings['image']['url']; 
          $image_html = '<img class="img-resposive" src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
          $this->mo_render_link_html($image_html); 
      endif; ?>
    </div>
    <div class="perspective_overlay"></div>
    <div class="perspective-caption">
        <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
          <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
        <?php } ?>
          <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title"  data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>
          <?php if($title_text){ ?> <h4 class="perspective-title" <?php echo $this->get_render_attribute_string( 'title_text' ); ?>><?php $this->mo_render_link_html($title_text, $settings['link']); ?></h4> <?php } ?>
          <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
            <div class="content"><?php echo wp_kses($description_text, true); ?></div>
          </div> 
        <?php if(!empty($settings['link']['url'])){ ?>
          <a class="btn_more_link" <?php $this->print_render_attribute_string('href') ?>><span class="mo_btn_text"><?php echo esc_html($settings['link_text']);?></span><span class="link_icon"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="20px" viewBox="0 0 30 18" enable-background="new 0 0 30 18" xml:space="preserve"><path class="handle" d="M20.305,16.212c-0.407,0.409-0.407,1.071,0,1.479s1.068,0.408,1.476,0l7.914-7.952c0.408-0.409,0.408-1.071,0-1.481l-7.914-7.952c-0.407-0.409-1.068-0.409-1.476,0s-0.407,1.071,0,1.48l7.185,7.221L20.305,16.212z"></path><path class="bar" fill-rule="evenodd" clip-rule="evenodd" d="M1,8h28.001c0.551,0,1,0.448,1,1c0,0.553-0.449,1-1,1H1c-0.553,0-1-0.447-1-1C0,8.448,0.447,8,1,8z"></path></svg></span></a>
      <?php } ?>
    </div>
  </div>
<?php } ?>  

<?php if($style == 'style2'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <?php $image_url = $settings['image']['url']; ?>
    <div class="box" <?php if (!empty($settings['image']['url'])) { echo 'style="background-image:url('.esc_url($image_url).')"'; }?>>
        <div class="box-container">
          <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
            <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
          <?php } ?>
          <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title"  data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>
          <?php if( $settings['title_text']) echo '<div class="title-wrap"><h6>'.$settings['title_text'].'</h6></div>'; ?>
        </div>
        <div class="box-overlay"></div>
      </div>
      <div class="box2" <?php if (!empty($settings['image']['url'])){ echo 'style="background-image:url('.esc_url($image_url).')"'; }?>>
        <div class="box-container2">
          <?php if( $settings['title_text']) echo '<div class="title-wrap"><h6>'.$settings['title_text'].'</h6></div>';?>
            <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
               <div class="content"><?php echo wp_kses($description_text, true); ?></div>
            </div>
            <?php if(!empty($settings['link']['url'])){ ?>
              <a class="button btn-txt text_center btn-txt-arrow light" <?php $this->print_render_attribute_string('href') ?>> <span class="mo_module_button__container"><span class="mo_module_button__cover front"><span class="mo_btn_text front"><?php echo esc_html($settings['link_text']);?></span></span><svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg></span></a>
            <?php } ?>
        </div>
        <div class="box-overlay"></div>
    </div>
  </div>
<?php } ?> 


<?php if($style == 'style3'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <?php if (!empty($settings['image']['url'])) : 
          $image_url = $settings['image']['url']; 
          $image_html = '<div class="image-bg"></div><div class="thumb-service"><img class="img-resposive" src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']).'"/></div>';
          $this->mo_render_link_html($image_html, $settings['link']); 
    endif; ?>
    <div class="title-wrap">
      <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
        <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
      <?php } ?>
      <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>
      <?php if( $settings['title_text']) echo '<h6>'.$settings['title_text'].'</h6>';?> 
      <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
        <div class="content"><?php echo wp_kses($description_text, true); ?></div>
      </div>
      <?php if(!empty($settings['link']['url'])){ ?>
        <a class="button btn-txt btn-txt-arrow3 dark hr_light" <?php $this->print_render_attribute_string('href') ?>><span class="mo_module_button__container"><span class="mo_module_button__cover front"><span class="mo_btn_text front"><?php echo esc_html($settings['link_text']);?></span></span></span></a>
      <?php } ?>
    </div>
  </div>
<?php } ?>


<?php if($style == 'style4'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <?php $image_url = $settings['image']['url']; ?>
    <div class="img-perspective2" <?php  echo 'style="background-image:url('.esc_url($image_url).')"'; ?>></div>
    <div class="perspective_overlay"></div>
    <div class="perspective-caption">
        <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
           <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
        <?php } ?>
        <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>
        <?php if( $settings['title_text']) echo '<h6 class="perspective-title">'.$settings['title_text'].'</h6>';?> 
        <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
           <div class="content"><?php echo wp_kses($description_text, true); ?></div>
        </div>
        <?php if(!empty($settings['link']['url'])){ ?>
          <a class="button btn-txt text_center btn-txt-arrow light" <?php $this->print_render_attribute_string('href') ?>> <span class="mo_module_button__container"><svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg></span></a>
        <?php } ?>
    </div>
  </div>
<?php } ?> 

<?php if($style == 'style5'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
      <?php $image_url = $settings['image']['url']; ?>
      <div class="img-perspective2" <?php  echo 'style="background-image:url('.esc_url($image_url).')"'; ?>></div>
      <div class="perspective_overlay"></div>
      <div class="perspective-caption">
        <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
          <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
        <?php } ?>
        <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>  
        <?php if( $settings['title_text']) echo '<h6 class="perspective-title">'.$settings['title_text'].'</h6>';  ?>
        <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
           <div class="content"><?php echo wp_kses($description_text, true); ?></div>
        </div>
        <div class="clearfix"></div>
        <?php if(!empty($settings['link']['url'])){ ?>
           <a class="btn-arrow" <?php $this->print_render_attribute_string('href') ?>><span class="mo_btn_text"><svg><path stroke="null" d="m26.875,13.1l-1.275,-1.275l3.625,-3.625l0.85,-0.575l-0.1,-0.3l-1.025,0.125l-29.45,0.125l-0.125,-1.7l29.575,-0.25l1.025,0.15l0.1,-0.3l-0.85,-0.575l-3.625,-3.625l1.275,-1.275l5.9,5.9l0,1.3l-5.9,5.9z"></path></svg></span></a>
        <?php } ?>

      </div>
  </div>
<?php } ?> 

<?php if($style == 'style6'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <div class="thumb-service">
      <?php if (!empty($settings['image']['url'])) : 
          $image_url = $settings['image']['url']; 
          $image_html = '<img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
          $this->mo_render_link_html($image_html, $settings['link']); 
      endif; ?>
      <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
        <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
      <?php } ?>
    </div>
    <div class="title-wrap">
      <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>  
      <?php if( $settings['title_text']) echo '<h6>'.$settings['title_text'].'</h6>'; ?>
      <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
        <div class="content"><?php echo wp_kses($description_text, true); ?></div>
      </div>
      <?php if(!empty($settings['link']['url'])){ ?>
        <a class="button btn-txt text_center btn-txt-arrow primary" <?php $this->print_render_attribute_string('href') ?>> <span class="mo_module_button__container"><span class="mo_module_button__cover front"><span class="mo_btn_text front"><?php echo esc_html($settings['link_text']);?></span></span><svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg></span></a>
      <?php } ?>
    </div>
  </div>
<?php } ?> 

<?php if($style == 'style7'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <?php $image_url = $settings['image']['url']; ?>
    <div class="caption"><img class="thumb-service" src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($settings['title_text']);?>" /></div>
    <div class="content-wrap">
       <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
          <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
       <?php } ?>
       <div class="title-wrap">
          <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>  
          <?php if( $settings['title_text']) echo '<h6>'.$settings['title_text'].'</h6>';  ?>
       </div>
       <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
         <div class="content"><?php echo wp_kses($description_text, true); ?></div>
       </div>
       <?php if(!empty($settings['link']['url'])){ ?>
          <a class="button btn-txt btn-txt-arrow3 dark hr_primary" <?php $this->print_render_attribute_string('href') ?>><span class="mo_module_button__container"><span class="mo_module_button__cover front"><span class="mo_btn_text front"><?php echo esc_html($settings['link_text']);?></span></span></span></a>
       <?php } ?>
    </div>
  </div>
<?php } ?> 


<?php if($style == 'style8'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
     <?php if (!empty($settings['image']['url'])) : 
        $image_url = $settings['image']['url']; 
        $image_html = '<img class="thumb-service" src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
        $this->mo_render_link_html($image_html, $settings['link']); 
    endif; ?>
    <div class="title-wrap">
        <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
           <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
        <?php } ?>
        <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>  
        <?php if( $settings['title_text']) echo '<h6>'.$settings['title_text'].'</h6>';  ?>
        <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
          <div class="content"><?php echo wp_kses($description_text, true); ?></div>
        </div>
        <?php if(!empty($settings['link']['url'])){ ?>
          <a class="btn-arrow" <?php $this->print_render_attribute_string('href') ?>><span class="mo_btn_text"><svg><path stroke="null" d="m26.875,13.1l-1.275,-1.275l3.625,-3.625l0.85,-0.575l-0.1,-0.3l-1.025,0.125l-29.45,0.125l-0.125,-1.7l29.575,-0.25l1.025,0.15l0.1,-0.3l-0.85,-0.575l-3.625,-3.625l1.275,-1.275l5.9,5.9l0,1.3l-5.9,5.9z"></path></svg></span></a>
        <?php } ?>
    </div>
  </div>
<?php } ?> 


<?php if($style == 'style9'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
     <?php if (!empty($settings['image']['url'])) : 
        $image_url = $settings['image']['url']; 
        $image_html = '<img class="thumb-service" src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
        $this->mo_render_link_html($image_html, $settings['link']); 
        ?>
        <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
          <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
       <?php } ?>
   <?php endif; ?>
    <div class="title-wrap">
        <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>  
        <?php if( $settings['title_text']) echo '<h6>'.$settings['title_text'].'</h6>';  ?>
        <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
          <div class="content"><?php echo wp_kses($description_text, true); ?></div>
        </div>
        <?php if(!empty($settings['link']['url'])){ ?>
          <a class="btn_more_link" <?php $this->print_render_attribute_string('href') ?>><span class="mo_btn_text"><?php echo esc_html($settings['link_text']);?></span><span class="link_icon"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="20px" viewBox="0 0 30 18" enable-background="new 0 0 30 18" xml:space="preserve"><path class="handle" d="M20.305,16.212c-0.407,0.409-0.407,1.071,0,1.479s1.068,0.408,1.476,0l7.914-7.952c0.408-0.409,0.408-1.071,0-1.481l-7.914-7.952c-0.407-0.409-1.068-0.409-1.476,0s-0.407,1.071,0,1.48l7.185,7.221L20.305,16.212z"></path><path class="bar" fill-rule="evenodd" clip-rule="evenodd" d="M1,8h28.001c0.551,0,1,0.448,1,1c0,0.553-0.449,1-1,1H1c-0.553,0-1-0.447-1-1C0,8.448,0.447,8,1,8z"></path></svg></span></a>
        <?php } ?>
    </div>
  </div>
<?php } ?> 


<?php if($style == 'style10'){ ?>
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
      <?php $image_url = $settings['image']['url']; ?>
      <div class="img-perspective2" <?php  echo 'style="background-image:url('.esc_url($image_url).')"'; ?>></div>
      <div class="perspective_overlay"></div>
      <div class="perspective-caption">
        <?php if ( ! empty( $settings['selected_icon']['value'] ) ) { ?>
          <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
        <?php } ?>
        <?php if( $settings['sup_title_text']) echo '<h5 class="sup-title" data-title="'.$settings['sup_title_text'].'"><span>'.$settings['sup_title_text'].'</span></h5>';?>  
        <?php if( $settings['title_text']) echo '<h6 class="perspective-title">'.$settings['title_text'].'</h6>';  ?>
        <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>>
            <div class="content"><?php echo wp_kses($description_text, true); ?></div>
        </div>
        <div class="clearfix"></div>
        <?php if(!empty($settings['link']['url'])){ ?>
           <a class="button btn-txt text_center btn-txt-arrow light" <?php $this->print_render_attribute_string('href') ?>> <span class="mo_module_button__container"><svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg></span></a>
        <?php } ?>
      </div>
  </div>
<?php } ?> 