<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
/**
 * Elementor icon box widget.
 *
 * Elementor widget that displays an icon, a headline and a text.
 *
 * @since 1.0.0
 */
class MOElement_Products extends MOElement_Base {  
     
    /**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-products';
	}

	/**
	 * Shortcode type.
	 *
	 * @since 3.2.0
	 * @var   string
	 */
	//protected $type = 'mo_products';

	/**
	 * [$post_type description]
	 * @var string
	 */
	private $post_type = 'product';

	/**
	 * Attributes.
	 *
	 * @since 3.2.0
	 * @var   array
	 */
	protected $attributes = array();

	/**
	 * Query args.
	 *
	 * @since 3.2.0
	 * @var   array
	 */
	protected $query_args = array();

	/**
	* [$taxonomies description]
	* @var array
	*/
	private $taxonomies = array( 'product_cat' );

	/**
	 * Get widget title.
	 *
	 * Retrieve icon box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'products', 'saga' );
	}
    /**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'woocommerce', 'products' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-products';
	}
	public function get_woo_category() {
		$return = array();
		if (class_exists('WooCommerce')) {
			$product_categories = get_terms('product_cat', 'orderby=count&hide_empty=0');
			if (is_array($product_categories)) {
				foreach ($product_categories as $cat) {
					$return[$cat->slug] = $cat->name . ' (' . $cat->slug . ')';
				}
			}
		}
		return $return;
	}
	/**
	 * Register icon box widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		// General Section
		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'General', 'saga' ),
			)
		);	
		
		$this->add_control(
            'woo-style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                  'tpl1' => esc_html__('Style 1', 'saga'),
                  'tpl2' => esc_html__('Style 2', 'saga'),
                ],
				'default' => 'tpl1',
            )
        );
		$this->add_control(
			'woo_category',
			array(
				'label'       => esc_html__( 'Product Category', 'saga' ),
				'description' => esc_html__( 'Leave an empty if you want to display all categories', 'saga' ),
				'type'        => Controls_Manager::SELECT2,
				'default'     => '',
				'multiple'    => true,
				'options'     => $this->get_woo_category(),
				'label_block' => true,
			)
		);
		$this->add_control(
			'rows_per_page',
			array(
				'label'       => esc_html__( 'Rows Per Page', 'saga' ),
				'description' => esc_html__( 'How many rows per page should be shown?', 'saga' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'1'  => '1',
					'2'  => '2',
					'3'  => '3',
					'4'  => '4',
					'5'  => '5',
					'6'  => '6',
					'7'  => '7',
					'8'  => '8',
					'9'  => '9',
					'10' => '10',
				),
				'default'     => 2,
			)
		);
		$this->add_control(
			'pagination',
			array(
				'label' => esc_html__( 'Show pagination', 'saga' ),
				'type'  => Controls_Manager::SWITCHER,
			)
		);	
		$this->add_control(
			'pagination_postion',
			array(
				'label'       => esc_html__( 'Pagination', 'saga' ),
				'description' => esc_html__( 'Show Pagination on the page', 'saga' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'center' => esc_html__( 'Center', 'saga' ),
					'left'   => esc_html__( 'Left', 'saga' ),
					'right'  => esc_html__( 'Right', 'saga' ),
				),
				'default'     => 'center',
				'condition'   => array(
					'pagination' => 'yes',
				)
			)
		);
		$this->add_control(
			'orderby',
			array(
				'label'       => esc_html__( 'Order by', 'saga' ),
				'description' => esc_html__( 'Select how to sort retrieved products', 'saga' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'date'          => esc_html__( 'Date', 'saga' ),
					'ID'            => esc_html__( 'ID', 'saga' ),
					'author'        => esc_html__( 'Author', 'saga' ),
					'modified'      => esc_html__( 'Modified', 'saga' ),
					'rand'          => esc_html__( 'Random', 'saga' ),
					'comment_count' => esc_html__( 'Comment count', 'saga' ),
					'menu_order'    => esc_html__( 'Menu Order', 'saga' ),
				),
				'default'     => 'menu_order',
			)
		);		
		$this->add_control(
			'order',
			array(
				'label'       => esc_html__( 'Order way', 'saga' ),
				'description' => esc_html__( 'Designates the ascending or descending order', 'saga' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'DESC' => esc_html__( 'Descending', 'saga' ),
					'ASC'  => esc_html__( 'Ascending', 'saga' ),
				),
				'default'     => 'DESC',
			)
		);		
		$this->end_controls_section();
		
		// Tab Style
		$this->start_controls_section(
			'style',
			array(
				'label' => esc_html__( 'Shop Styles', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE
			)
		);		
		$this->add_control(
			'grid_gap',
			array(
				'label'      => esc_html__( 'Grid Gap', 'saga' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
					'%'  => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default'    => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors'  => array(
					'{{WRAPPER}} .mo-products-grid .products article' => 'margin-right: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .mo-products-grid .products article' => 'margin-right: {{SIZE}}{{UNIT}};margin-bottom: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'dropdown_prod_orderby',
			array(
				'label'       => esc_html__( 'Dropdown on Frontend - Order by', 'saga' ),
				'description' => esc_html__( 'Show the dropdown to change the Sorting of products displayed per page', 'saga' ),
				'type'        => Controls_Manager::SWITCHER,
			)
		);
		$this->end_controls_section();
	}
	/**
	 * Render icon box widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-products.php');
      print '</div>';
	}
}