<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

/**
 * Elementor heading widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class MOElement_Pricing_Block extends MOElement_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-pricing-block';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve heading widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pricing Block', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-list';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'pricing', 'block' ];
	}
	public function get_script_depends() {
		return [
		   'jquery.waypoint',
		   'saga.elements',
		];
	 }
	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'saga' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style1' 		=> __( 'Style 1', 'saga' ),
					'style2' 		=> __( 'Style 2', 'saga' ),
					'style3' 		=> __( 'Style 3', 'saga' ),
					'style4' 		=> __( 'Style 4', 'saga' ),
				],
				'default' => 'style1',
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'saga' ),
				'default' => __( 'Standard', 'saga' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'price',
			[
				'label' => __( 'Price', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( '60.00', 'saga' ),
				'default' => __( '60.00', 'saga' ),
			]
		);
		$this->add_control(
			'currency',
			[
				'label' => __( 'Currency', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Currency', 'saga' ),
				'default' => __( '$', 'saga' ),
			]
		);
		$this->add_control(
			'period',
			[
				'label' => __( 'Period', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Monthly', 'saga' ),
				'default' => __( 'Monthly', 'saga' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$this->add_control(
            'best_label',
            array(
                'label'     => esc_html__('Best Label', 'saga'),
                'type'      => Controls_Manager::SWITCHER,
            )
        );
        $this->add_control(
			'txt_label',
			[
				'label' => __( 'label', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'label Test', 'saga' ),
				'default' => __( 'POPULAR', 'saga' ),
				'condition'   => array(
					'best_label!' => '',
				),
			]
		);
		$this->end_controls_section();



		$this->start_controls_section( 
			'section_features',
			[
				'label' => __( 'Features', 'saga' ),
			]
		);
		$this->add_control(
			'pricing_content',
			[
			   'label'       => __('Pricing List', 'saga'),
			   'type'        => Controls_Manager::REPEATER,
			   'fields'      => [
					 [
					 'name'        => 'pricing_features',
					 'label'       => __('Pricing Features', 'saga'),
					 'type'        => Controls_Manager::TEXT,
					 'default'     => 'Free text goes here',
					 'label_block' => true,
					 'rows'        => '10',
					 ],
					 [
						 'name'        => 'selected_icon',
					 'label'       => __('Icon', 'saga'),
					 'type'        => Controls_Manager::ICONS,
					 'fa4compatibility' => 'icon',
						   'default' => [
							   'value' => 'fas fa-check',
							   'library' => 'fa-solid',
						   ],
					 ]
			   ],
			   'title_field' => '{{{ pricing_features }}}',
			   'default'     => array(
				  array(
					 'pricing_features'  => esc_html__( 'High speed internet', 'saga' ),
					 'selected_icon' => array('value' => 'fas fa-check', 'library' => 'fa-solid')
				  ),
				  array(
					 'pricing_features'  => esc_html__( 'Free parking space', 'saga' ),
					 'selected_icon' => array('value' => 'fas fa-check', 'library' => 'fa-solid')
				  ),
				  array(
					 'pricing_features'  => esc_html__( 'Free parking space', 'saga' ),
					 'selected_icon' => array('value' => 'fas fa-check', 'library' => 'fa-solid')
				  ),
				  array(
					 'pricing_features'  => esc_html__( 'Full access', 'saga' ),
					 'selected_icon' => array('value' => 'fas fa-check', 'library' => 'fa-solid')
				  )
			   ),
			]
		 );
		$this->end_controls_section();





		$this->start_controls_section( 
			'section_Button',
			[
				'label' => __( 'Button', 'saga' ),
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' => __( 'Button URL', 'saga' ),
				'type' => Controls_Manager::URL,
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __( 'Button Text', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Read More'
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-pricing-block.php');
      print '</div>';
	}

}
