<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

/**
 * Elementor heading widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class MOElement_Navigation_Menu extends MOElement_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-navigation-menu';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve heading widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Navigation Menu', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-nav-menu';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'menu', 'navigation' ];
	}

	public function get_all_menus(){
	   $menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) ); 
	   $results = array();
	   foreach ($menus as $key => $menu) {
	   	$results[$menu->slug] = $menu->name;
	   }
	   return $results;
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'saga' ),
			]
		);

		$this->add_control(
			'menu',
			[
				'label' 			=> __( 'Menu', 'saga' ),
				'type' 			=> Controls_Manager::SELECT,
				'options' 		=> $this->get_all_menus(),
				'label_block' 	=> true,
				'default'		=> 'main-menu'
			]
		);

		$this->add_control(
			'align',
			[
				'label' => __( 'Alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'center',
			]
		);

		$this->add_control(
			'sub_menu_min_width',
			[
				'label' => __( 'Submenu Min Width (px)', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 250,
				],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li .submenu-inner, .mo-navigation-menu ul.mo-nav-menu > li ul.submenu-inner' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
	
		$this->end_controls_section();

		//Styling Main Menu
		$this->start_controls_section(
			'section_main_menu_style',
			[
				'label' => __( 'Main Menu', 'saga' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		//Tabs Styling Normal, Hover, Active
      $this->start_controls_tabs('tabs_main_menu_style');

      $this->start_controls_tab(
         'main_menu_style_normal',
         [
            'label' => __('Normal', 'saga'),
         ]
      );
      $this->add_control(
         'main_menu_text_color',
         [
            'label'     => __('Text Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li' => 'color: {{VALUE}}', 
            ],
         ]
      );
      $this->add_control(
         'main_menu_color',
         [
            'label'     => __('Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li > a' => 'color: {{VALUE}}',
            ],
         ]
      );
      $this->end_controls_tab();

      $this->start_controls_tab(
         'main_menu_hover',
         [
            'label' => __('Hover', 'saga'),
         ]
      );
      $this->add_control(
         'main_menu_hover_color',
         [
            'label'     => __('Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li > a:hover' => 'color: {{VALUE}}', 
            ],
         ]
      );
      $this->end_controls_tab();

      $this->start_controls_tab(
         'main_menu_active',
         [
            'label' => __('Active', 'saga'),
         ]
      );
      $this->add_control(
         'main_menu_active_color',
         [
            'label'     => __('Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li.current_page_parent > a' => 'color: {{VALUE}}', 
            ],
         ]
      );
      $this->end_controls_tab();

      $this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => 0,
				'selector' => '{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li > a',
			]
		);

		$this->add_responsive_control(
			'main_menu_padding',
			[
				'label' => __( 'Menu Item Padding', 'saga' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .mo-navigation-menu ul.mo-nav-menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		//Styling Sub Menu
		$this->start_controls_section(
			'section_sub_menu_style',
			[
				'label' => __( 'Sub Menu', 'saga' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		//Tabs Styling Normal, Hover, Active
      $this->start_controls_tabs('tabs_sub_menu_style');

      $this->start_controls_tab(
         'sub_menu_style_normal',
         [
            'label' => __('Normal', 'saga'),
         ]
      );
      $this->add_control(
         'sub_menu_text_color',
         [
            'label'     => __('Text Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner' => 'color: {{VALUE}}', 
            ],
         ]
      );
      $this->add_control(
         'sub_menu_color',
         [
            'label'     => __('Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner a' => 'color: {{VALUE}}',
            ],
         ]
      );
      $this->end_controls_tab();

      $this->start_controls_tab(
         'sub_menu_hover',
         [
            'label' => __('Hover', 'saga'),
         ]
      );
      
      $this->add_control(
         'sub_menu_hover_color',
         [
            'label'     => __('Link Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner a:hover' => 'color: {{VALUE}}', 
               '{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner a:active' => 'color: {{VALUE}}', 
            ],
         ]
      );
      $this->end_controls_tab();

      $this->start_controls_tab(
         'sub_menu_active',
         [
            'label' => __('Active', 'saga'),
         ]
      );
      $this->add_control(
         'sub_menu_active_color',
         [
            'label'     => __('Color', 'saga'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner li.current_page_parent a:hover' => 'color: {{VALUE}}', 
            ],
         ]
      );
      $this->end_controls_tab();

      $this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_2',
				'scheme' => 0,
				'selector' => '{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner li a',
			]
		);

		$this->add_responsive_control(
			'sub_menu_padding',
			[
				'label' => __( 'Menu Item Padding', 'saga' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .mo-navigation-menu ul.mo-main-menu .submenu-inner li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
        include $this->get_template('mo-navigation-menu.php');
      print '</div>';
	}
}
