<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_Brand extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-brand';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Brand', 'saga');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_keywords() {
        return [ 'brand', 'content', 'carousel' ];
    }

    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'saga.elements',
      ];
    }

    public function get_style_depends() {
      return array('owl-carousel-css');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'saga'),
            ]
        );
        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title',
			[
				'label'       => __('Title', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'default'     => 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'image',
			[
                'label'      => __('Choose Image', 'saga'),
                'default'    => [
                    'url' => SAGA_URI . 'elementor/assets/images/brand.png',
                ],
                'dynamic' => [
                  'active' => true,
                ],
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
			]
		);
        $repeater->add_control(
			'link',
			[
				'label'      => __('Link', 'saga'),
                'placeholder' => __( 'https://your-link.com', 'saga' ),
                'type'       => Controls_Manager::URL,
			]
		);
        $this->add_control(
            'brands',
            [
                'label'       => __('Brand Content Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
                'default'     => array(
                    array(
                        'title'  => esc_html__( 'Brand 1', 'saga' )
                    ),
                    array(
                        'title'  => esc_html__( 'Brand 2', 'saga' )
                    ),
                    array(
                        'title'  => esc_html__( 'Brand 3', 'saga' )
                    ),
                    array(
                        'title'  => esc_html__( 'Brand 4', 'saga' )
                    ),
                    array(
                        'title'  => esc_html__( 'Brand 5', 'saga' )
                    ),
                    array(
                        'title'  => esc_html__( 'Brand 6', 'saga' )
                    ),
                ),
            ]
        );

        $this->add_control(
            'design',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'style1' => esc_html__('Style 1', 'saga'),
                  'style2' => esc_html__('Style 2', 'saga'),
                  'style3' => esc_html__('Style 3', 'saga'),
                ],
				'default' => 'style1',
            )
         );

        $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Row style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-2',
                'options' => [
                  'style-2' => esc_html__('Carousel 1 Row', 'saga'),
                  'style-1' => esc_html__('Carousel 2 Rows', 'saga'),
                ]
            )
        );
        $this->end_controls_section();

        $this->add_control_carousel(false);
    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
        include $this->get_template('mo-brand.php');
      print '</div>';
    }
}