/**
 * jquery.saga_core.admin.js
 * Author: saga
 * Author Uri: http://saga.com
 * Email: saga@gmail.com
 * Version: 1.0
 */

! ( function( $ ) {
	'use strict';

	var sagaAPI = function() {
		this.init();
	}

	sagaAPI.prototype = {
		init: function() {
			this.accordionHandle();
			this.backupdatabaseHandle();
		},
		accordionHandle: function() {
			$( '.saga-block-accordion-wrap' ).each( function() {
				var $accordionWrap = $( this );

				$accordionWrap.find( '.saga-block-accordion-body' ).slideUp( 0 );
				$accordionWrap.find( '.saga-block-accordion' ).first().find( '.saga-block-accordion-body' ).slideDown( 'slow' );

				$accordionWrap.on( 'click', '.saga-block-accordion > .title', function() {
					var $accordionItem = $( this ).parent( '.saga-block-accordion' );
					$accordionWrap.find( '.saga-block-accordion-body' ).slideUp( 'slow' );
					$accordionItem.find( '.saga-block-accordion-body' ).slideDown( 'slow' );
				} )
			} )
		},
		backupdatabaseHandle: function() {
			$( 'body' ).on( 'click', '#saga-backupdatabase-handle', function( e ) {
				e.preventDefault();
				var $this = $( this ),
					path = $( this ).data( 'path' ),
					uri = $( this ).data( 'uri' );

				$this.addClass( 'saga-ajax-loading' );

				$.ajax( {
					type: 'POST',
					url: saga_object.ajax_url,
					data: { action: 'saga_backupDatabase_handle', path: path, uri: uri },
					success: function( result ) {
						// console.log( result );
						$this.removeClass( 'saga-ajax-loading' );
						$this.parents( '.saga-block-accordion-body' ).append( $( result ).css( 'display', 'none' ).fadeIn( 'slow' ) );
					},
					error: function( e ) {
						alert( JSON.stringify( e ) );
						console.log( e )
					}
				} )
			} )

			/* Restore */
			$( 'body' ).on( 'click', 'a.saga-restore-database', function( e ) {
				e.preventDefault();

				var $this = $( this ),
					$rowElem = $( this ).parents( '.table-row' ),
					file = $( this ).data( 'file' ),
					ask = confirm( 'Do you want RESTORE database?' );

				if( ask == true ) {
				    $rowElem.addClass( 'saga-ajax-loading' );

				    $.ajax( {
						type: 'POST',
						url: saga_object.ajax_url,
						data: { action: 'saga_restoreDatabase_handle', file: file },
						success: function( result ) {
							alert( result );
							$rowElem.removeClass( 'saga-ajax-loading' );
							console.log( result );
						},
						error: function( e ) {
							alert( JSON.stringify( e ) );
							console.log( e )
						}
					} )
				}
			} )

			/* Delete */
			$( 'body' ).on( 'click', 'a.saga-delete-database', function( e ) {
				e.preventDefault();

				var $rowElem = $( this ).parents( '.table-row' ),
					file = $( this ).data( 'file' ),
					ask = confirm( 'Do you want DELETE this file?' );

				if( ask == true ) {
				    $rowElem.addClass( 'saga-ajax-loading' );

				    $.ajax( {
						type: 'POST',
						url: saga_object.ajax_url,
						data: { action: 'saga_deleteDatabase_handle', file: file },
						success: function( result ) {
							alert( result );
							$rowElem.fadeOut( 'slow', function() { $( this ).remove() } );
							console.log( result );
						},
						error: function( e ) {
							alert( JSON.stringify( e ) );
							console.log( e )
						}
					} )
				}
			} )
		}
	}

	/* DOM Reaady */
	$( function() {

		/* use sagaAPI */
		new sagaAPI();
	} ) 
} )( jQuery )
