<?php
// Function to generate random folder name
function generateRandomFolderName($length = 16) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}

// Set base upload directory
$baseUploadDir = __DIR__ . '/uploads/';

// Create base upload directory if it doesn't exist
if (!is_dir($baseUploadDir)) {
    mkdir($baseUploadDir, 0755, true);
}

// Generate random folder for this session
$sessionFolder = generateRandomFolderName();
$uploadDir = $baseUploadDir . $sessionFolder . '/';

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    // Create the session folder if it doesn't exist
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $file = $_FILES['file'];
    $fileName = basename($file['name']);
    $targetFile = $uploadDir . $fileName;

    // Check for errors
    if ($file['error'] !== 0) {
        die("Error: File upload failed.");
    }

    // Move file to upload directory
    if (move_uploaded_file($file['tmp_name'], $targetFile)) {
        echo "File uploaded successfully: <a href='uploads/$sessionFolder/$fileName'>$fileName</a>";
    } else {
        echo "Error: Unable to upload file.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP File Uploader</title>
</head>
<body>
    <h2>Upload a File</h2>
    <form action="" method="post" enctype="multipart/form-data">
        <input type="file" name="file" required>
        <button type="submit">Upload</button>
    </form>
</body>
</html>